<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_DataWriter_DiscussionMessage_Post extends XFCP_sonnbStopSpamHere_DataWriter_DiscussionMessage_Post
{
    protected function _messagePreSave()
    {
        parent::_messagePreSave();
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE]))
        {
            $this->set('message_state', 'moderated');
        }
    }
    
    protected function _messagePostSave()
    {
        parent::_messagePostSave();

        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_ALLOW]))
        {
        	$this->addLog(
        			$GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_ALLOW]['type'],
        			sonnbStopSpamHere_Model_SSH::ACTION_ALLOW,
        			$GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_ALLOW]['data']
        	);
        
        	unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_ALLOW]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_MODERATE,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION]))
        {
            sonnbStopSpamHere_Model_Moderate::sendPC(
                XenForo_Visitor::getInstance(),
                XenForo_Link::buildPublicLink('posts', $this->getMergedData()),
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION]
            );
            
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_CONVERSATION,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT]))
        {                        
            sonnbStopSpamHere_Model_Moderate::sendReport(
                'post',
                array(
                    'post_id' => $this->get('post_id'),
                    'user_id' => $this->get('user_id')
                ),
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT]
            );
            
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_REPORT,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT]);
        }
        
    }
    
    public function addLog($type, $action, array $data = array())
    {
        $sshModel = new sonnbStopSpamHere_Model_SSH;
        $sshModel->saveLog(
            array(
                'content_type' => sonnbStopSpamHere_Model_SSH::TYPE_POST,
                'content_id' => $this->get('post_id'),
                'log_type' => $type,
                'data' => serialize($data),
                'action' => $action
            )
        );
    }
}